/*  eslint-disable no-template-curly-in-string */
const strings = {
    app_name: 'Cardo Update',
    tooltip_app_version: 'Version ${version}',
    tooltip_more_info: 'For more info...',
    welcome_title: 'Welcome to Cardo Update!',
    welcome_subtitle:
        'Cardo Update keeps your unit up to date with the latest firmware and features.',
    welcome_new_app_version_available:
        'A new version of Cardo Update available!',
    welcome_new_app_version_available_description:
        'Please update to the newest version to continue using Cardo Update',
    welcome_download_app_update: 'Download Update',
    welcome_install_app_update: 'Install and Relaunch',
    welcome_downloading_app_update: 'Downloading a new version of Cardo Update',
    welcome_device_connecting:
        'Connecting, please do not disconnect your unit...',
    welcome_downloading_app_update_complete: 'Download Complete',
    welcome_no_device_connected_description:
        'Simply connect your unit to your computer using the Cardo USB cable',
    welcome_modal_device_fw_interrupted_title: 'Firmware issue detected',
    welcome_modal_device_fw_interrupted_description:
        'Unexpected firmware issue has occurred on your unit. Please install new firmware update.',
    general_link_need_support: 'Need support?',
    unsupported_unit_header: 'Unsupported unit connected',
    unsupported_unit_title:
        'Cardo update is not compatible with the connected unit',
    unsupported_unit_subtitle:
        'Please, <a href="${url}" target="_blank">click here</a> to find the correct update tool',
    update_device_header: '${name} - connected',
    update_device_checking_for_updates: 'Checking for updates...',
    update_device_no_internet_title:
        "Sorry, Cardo Update can't check for updates at the moment.",
    update_device_no_internet_description:
        'Please make sure you have a good network connection and try again.',
    update_device_firmware_selection_modal_title:
        'Select firmware version to install',
    update_device_firmware_selection_latest_version:
        '${version} version - Official release',
    update_device_firmware_selection_beta_version:
        '${betaVersion} version - Beta (Build ${betaBuildNumber})',
    update_device_firmware_selection_custom_version: '${version} version',
    general_button_retry: 'Try again',
    update_device_new_fw_available_title: 'Firmware update available!',
    update_device_new_fw_available_release_link: "What's new?",
    update_device_new_fw_available_update_firmware: 'Update firmware',
    update_device_updating_title: 'Updating firmware...',
    update_device_updating_description:
        'Do not disconnect your unit until the update is completed.',
    update_device_status_downloading_version_info:
        'Downloading version info...',
    update_device_status_downloading_fw: 'Downloading firmware...',
    update_device_status_installing_fw: 'Installing firmware...',
    update_device_footer_follow: 'Follow us on:',
    update_device_footer_jbl: 'Want better sound?',
    problem_updating_fw_title: 'There is a problem upgrading firmware.',
    problem_updating_fw_subtitle:
        'Please check your USB connection and try again.',
    problem_updating_fw_back_to_main_button: 'Back to main',
    problem_updating_fw_help:
        'If this issue continues, please <a href="${url}" target="_blank">contact support</a>',
    problem_recognizing_device_error:
        'Connection issue detected, unit isn’t recognized. Please reconnect unit and try again',
    update_device_done_title: 'All done!',
    update_device_done_subtitle: 'Your unit is up to date.',
    update_application_error: 'Failed to download update',
    update_application_error_descrition:
        'Sorry, something went wrong, and update wasn’t downloaded',
    close_app_popup_title: 'Quit Cardo Update?',
    close_app_popup_body:
        'Don’t close Cardo Update before the update is complete',
    close_app_popup_quit: 'Quit',
    device_up_to_date_title: 'Your firmware is up to date',
    device_firmware_version_is:
        'Your current firmware version is ${version} ${betaBuildNumber}',
    device_up_to_date_subtitle: 'Last updated: ${date}',
    device_up_to_date_reinstall_firmware_button: 'Reinstall firmware',
    device_up_to_date_reinstall_firmware_popup:
        'Reinstall the latest firmware version',
    device_info_model: 'Model',
    device_info_current_fw: 'Current firmware',
    device_info_serial: 'Serial number',
    button_cancel: 'Cancel',
    button_install: 'Install',
    button_ok: 'OK',
    general_device: 'Unit',
    support: 'Support',
    not_logged_in_title: 'Update My Cardo To Keep It Fresh',
    not_logged_in_sub_title: 'Newest Features · Bug Fixes',
    sign_in: 'Sign In',
    email: 'Email',
    dont_have_an_account: "Don't have an account?",
    sign_up: 'Sign Up',
    email_doesnt_exist: "Email doesn't exist. Try another email or sign up",
    network_error: 'Network Error - try again',
    back_to_sign_in: 'Back to Sign In',
    back_to_sign_up: 'Back to Sign Up',
    verify_your_email_address: 'Verify Your Email Address',
    we_sent_verification_email:
        'We have just sent you a verification email to <b>${email}</b>. Please check your email.',
    didnt_receive_an_email: "Didn't receive an email?",
    send_again: 'Send Again',
    first_name: 'First Name',
    last_name: 'Last Name',
    continue: 'Continue',
    already_have_an_account: 'Already have an account?',
    email_already_registered:
        'This email is already registered. Try another email or sign in.',
    country: 'Country',
    date_of_birth: 'Date of Birth',
    marketing_approval:
        'I agree that Cardo Systems may email me marketing updates and software upgrade notifications.',
    by_clicking_sign_up:
        'By clicking "Sign Up" you consent to our <a href="${privacy_url}" target="_blank">Privacy Policy</a> and <a href="${tos_url}" target="_blank">Terms &amp; Conditions</a>',
    back: 'Back',
    sign_out: 'Sign out',
    software_version: 'Software version',
    complete_your_details: 'Complete Your Details',
    done_button: 'Done',
    invalid_email_format: 'Email format, example@email.com',
    letters_only: 'Letters only',
    sign_out_confirmation: 'Are you sure you want to sign out?',
    yes: 'Yes',
    no: 'No',
    no_internet_connection: 'No Internet connection!',
    your_connection_was_lost:
        'Your internet connection was lost. Please reconnect and TRY AGAIN',
    do_not_close_app: 'Do not close the app',
    no_results: 'No Results',
    fw_language: 'Unit language',
    usb_connection_error:
        'USB connection error detected. Please connect your unit to a mobile phone and use the Cardo Connect mobile app to update your software',
    manual_download_description:
        'Please download latest Cardo Update version manually by clicking the button below',
    download: 'Download'
};

export default strings;
